package dámy;
import java.util.stream.Stream;

/**
 * Řešitel úlohy N dam
 * @author virius
 */
public class Řešitel
{
    private final int N;
    private final int[] řešení;
    //private int[] p = null;
    int početNalezenýchŘešení = 0;
    long početVolání = 0;

    /**
     * Vytvoří a vrátí datovod (proud) obsahující všechna řešení úlohy
     * n dam.
     * @param n Počet dam
     * @return datovod obsahující všechna řešení úohy n dam
     */
    public static Stream<int[]> datovod(int n)
    {
        Řešitel řešitel = new Řešitel(n);
        return Stream.generate(()-> řešitel.najdiDalšíŘešení() ? řešitel.řešení : null).takeWhile(s -> s != null);
    }

    /**
     * Vrátí poslední nalezené řešení. Tuto metodu je třeba volat po volání
     * metody NajdiDalšíŘešení() nebo NajdiDalšíŘešeníOdŘádky(), jestliže
     * toto volání vrátí true.
     * @return Vrátí pole typu int[n] obsahující řešení.
     */
    public int[] getŘešení()
    {
        return řešení;
    }

    /**
     * Vrátí počet dosud nalezených řešení úlohy N dam
     * @return počet dosud nalezených řešení úlohy N dam
     */
    public int getPočetNalezenýchŘešení()
    {
        return početNalezenýchŘešení;
    }

    /**
     * Vrátí počet volání metody bezpečná()
     * @return počet dodud realizovaných volání metody bezpečně(),
     * tedy počet testovaných políček šachovnice; slouží jako míra
     * složitosti úlohy
     */
    public long getPočetTestovanýchPolíček()
    {
        return početVolání;
    }

    /**
     * Konstruktor třídy řešitel
     * Vytvoří instanci řešitele pro zadaný počet dam
     * @param n Počet dam
     */
    public Řešitel(int n)
    {
        if (n < 4) throw new IllegalArgumentException("Počet dam musí být větší než 3");
        N = n;
        řešení = new int[N];
        for(int i = 0; i < n; i++)
        {
            řešení[i] = -1;
        }
    }

    /**
     * test, zda je dané políčko bezpečné
     * @return true, když lze dámu na dané políčko postavit a není ohrožena,
     * false v opačném případě
     * @param řádka číslo řádky
     * @param sloupec číslo sloupce
     */
    private boolean bezpečná(int řádka, int sloupec)
    {
        početVolání++;
        if (sloupec == 0)
        {
            return true;    // V prvním sloupci lze umístit kamkoli
        }
        var výsledek = true;
        var j = 0;
        while (výsledek && (j < sloupec))         // Projdi všechny předchozí sloupce
        {
            výsledek = (řešení[j] != řádka) &&      // stejná řádka?
                    (řešení[sloupec - j - 1] != řádka - j - 1) && // stejná diagonála?
                    (řešení[sloupec - j - 1] != řádka + j + 1);
            if (!výsledek)
            {
                return false;
            }
            j++;
        }
        return true;
    }


    /**
     * Najde další možné umístění v daném sloupci, začne za danou řádkou
     * @return číslo řádky, kam lze umístit dámu; je-li rovno N (počet dam),
     * nepodařilo se bezpečnou řádku najít
     * @param řádka číslo řádky
     * @param sloupec číslo sloupce
     */
    private int najdiDalšíBezpečnouŘádku(int řádka, int sloupec)
    {

        while (++řádka < N)
        {
            if (bezpečná(řádka, sloupec))
            {
                break;
            }
        }
        return řádka;                           // Neuspěje-li, vrátí N
    }

    /**
     * Začne hledat další řešení počínaje daným sloupcem
     * @return pole obsahující další řešení, pokud existuje,
     * jinak vrátí null
     * @param sloupec číslo sloupce
     */
    private int[] řešOdSloupce(int sloupec)
    {
        int k;
        while (sloupec > -1)
        {
            k = najdiDalšíBezpečnouŘádku(řešení[sloupec], sloupec);
            if (k < N)
            {
                řešení[sloupec++] = k;
                if (sloupec == N) return řešení;
            }
            else řešení[sloupec--] = -1;
        }
        return null;
    }

    /**
     * Najde další řešení úlohy N dam
     * @return true, jestliže se další řešení podařilo najít,
     * jinak vrátí false
     */
    public boolean najdiDalšíŘešení()
    {
        int[] výsledek = početNalezenýchŘešení == 0 ? řešOdSloupce(0) : řešOdSloupce(N - 1);
        if (výsledek != null)
        {
            početNalezenýchŘešení++;
        }
        return výsledek != null;
    }

    /**
     * Projde ostupně všechna existující řešení
     * výsledkem je, že datová složka početNalezenýchŘešení
     * obsahuje počet řešení úlohy
     */
    @SuppressWarnings("empty-statement")
    public void najdiVšechnaŘešení()
    {
        while (najdiDalšíŘešení())
            ;
    }

    /**
     * Projde postupně všechna existující řešení,
     * kde je dáma v prvním sloupci umístěna v zadané řádce.
     * Výsledkem je, že datová složka
     * početNalezenýchŘešení obsahuje počet takovýchto řešení.
     * @param řádka Řádka, na níž je umístěna první dáma
     */
    @SuppressWarnings("empty-statement")
    public void najdiVšechnaŘešeníOdŘádky(int řádka)
    {
        while(najdiDalšíŘešeníOdŘádky(řádka))
            ;
    }

    /**
     * Najde další řešení úlohy N dam, kde je dáma v prvním
     * sloupci umístěna v zadané řádce.
     * @param řádka Řádka, na níž je umístěna první dáma
     * @return true, jestliže se další řešení podařilo najít,
     * jinak vrátí false
     */
    public boolean najdiDalšíŘešeníOdŘádky(int řádka)
    {
        if(řešení[0] == -1) řešení[0] = řádka;
        int[] výsledek = početNalezenýchŘešení == 0 ? řešOdSloupce(1) : řešOdSloupce(N - 1);
        if(výsledek != null && řešení[0] == řádka)
        {
            početNalezenýchŘešení++;
        }
        return výsledek != null && řešení[0] == řádka;
    }

    /**
     * Vypíše poslední nalezené řešení
     */
    public void výpis()
    {
        StringBuilder výsledek = new StringBuilder("(");
        for(int i = 0; i < řešení.length; i++)
        {
            výsledek.append(i == 0 ? "" : ", ").append(řešení[i]);
        }
        výsledek.append(")");
        System.out.println(výsledek.toString());

    }
}
